/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.partida;

import es.pyronixstudio.base.comandos.Argumentos;
import es.pyronixstudio.base.componentes.SistemaComponente;
import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.AbstractPlayerTeamFactory;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.equipo.EquipoManager;
import es.pyronixstudio.base.juego.equipo.FundidoManager;
import es.pyronixstudio.base.juego.partida.CuentaAtras;
import es.pyronixstudio.base.juego.partida.EnumEstadoPartida;
import es.pyronixstudio.base.juego.partida.ResetManager;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.juego.partida.jugador.JugadorManager;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.registros.tipo.IRegistro;
import es.pyronixstudio.base.sonido.SonidoBase;
import es.pyronixstudio.base.sonido.SonidoManager;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public abstract class AbstractPartida<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements Listener {
    protected EnumEstadoPartida estado = EnumEstadoPartida.EN_ESPERA;
    protected final AbstractPlayerTeamFactory<J, E, P> creadorJugadoresEquipos;
    public final ResetManager resetManager;
    public final EquipoManager<J, E, P> equipoManager;
    public final JugadorManager<J, E, P> jugadorManager;
    public PyronixPlugin<J, E, P> plugin;
    private final String bloqueAsignarEquipo = Optional.ofNullable(PyronixPlugin.INSTANCE.getConfig().getString("bloqueAsignarEquipo")).orElse("glazed_terracotta");
    public final SistemaComponente componentSystem = SistemaComponente.create();

    protected AbstractPartida() {
        this.resetManager = new ResetManager(this);
        this.equipoManager = new EquipoManager();
        this.jugadorManager = new JugadorManager();
        this.creadorJugadoresEquipos = this.getCreador();
    }

    public final void setPlugin(PyronixPlugin<J, E, P> plugin) {
        this.plugin = plugin;
    }

    public final EnumEstadoPartida getEstado() {
        return this.estado;
    }

    public final synchronized void setEstado(EnumEstadoPartida estadoPartida) {
        this.estado = estadoPartida;
    }

    public final void volverAPreinicializarEquiposYJugadores() {
        this.equipoManager.ejecutarFuncionTodosLosEquipos(equipo -> {
            this.creadorJugadoresEquipos.preInicializarBase((AbstractEquipo)equipo);
            equipo.getJugadores().forEach(uuid -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                Wrapper<J> jugadorOptional = this.jugadorManager.get((UUID)uuid);
                if (jugadorOptional.isEmpty() && player != null && player.isOnline()) {
                    this.jugadorManager.add((UUID)uuid, this.creadorJugadoresEquipos.crearJugador(player, (AbstractEquipo)equipo, false));
                }
            });
        });
    }

    public abstract void crear(Argumentos var1);

    public final void preIniciar(Argumentos argumentos) {
        this.preIniciarExtra(argumentos);
        this.equipoManager.ejecutarFuncionTodosLosEquipos(AbstractEquipo::preIniciar);
        this.iniciar(argumentos);
        if (argumentos.asError()) {
            this.reset();
        }
    }

    protected void preIniciarExtra(Argumentos argumentos) {
    }

    protected abstract void iniciar(Argumentos var1);

    protected abstract void terminarExtra();

    public void terminar() {
        this.setEstado(EnumEstadoPartida.TERMINADA);
        this.terminarExtra();
        SonidoManager.reproducirAudioATodosEnPartida(this.jugadorManager, RegistrosBase.SONIDOS.PARTIDA_TERMINADA, 1.0f, 1.0f);
    }

    public abstract AbstractPlayerTeamFactory<J, E, P> getCreador();

    public void meterJugadoresAEquipo() {
        int maxColores = EnumColor.values().length;
        for (Player player : Bukkit.getOnlinePlayers()) {
            EnumColor colorEnum;
            Material bloqueAbajo = player.getLocation().add(0.0, -1.0, 0.0).getBlock().getType();
            UUID uuidJugador = player.getUniqueId();
            if (!bloqueAbajo.toString().toLowerCase().contains(this.bloqueAsignarEquipo.toLowerCase()) || this.jugadorManager.get(uuidJugador).isPresent() || (colorEnum = EnumColor.getEnumFromMaterial(bloqueAbajo)) == null || this.equipoManager.getCantidad() > maxColores && !this.equipoManager.hayColor(colorEnum)) continue;
            E equipoCreado = this.equipoManager.agregar(colorEnum, this.creadorJugadoresEquipos.crearEquipo(colorEnum));
            ((AbstractEquipo)equipoCreado).agregarJugador(uuidJugador);
            this.jugadorManager.add(uuidJugador, this.creadorJugadoresEquipos.crearJugador(player, equipoCreado, true));
        }
    }

    protected void cuentaAtras(Runnable alTerminar) {
        this.cuentaAtras(alTerminar, 5);
    }

    protected void cuentaAtras(Runnable alTerminar, int delayAntesDeEjecucion) {
        this.cuentaAtras(alTerminar, delayAntesDeEjecucion, null);
    }

    protected void cuentaAtras(Runnable alTerminar, int delayAntesDeEjecucion, IRegistro<SonidoBase> sonidoAJugar) {
        CuentaAtras.nuevaCuentaAtras(this, alTerminar, delayAntesDeEjecucion, sonidoAJugar == null ? RegistrosBase.SONIDOS.A_JUGAR : sonidoAJugar);
    }

    protected final void fundidoNegro(FundidoManager.IFundidoNegro<J, E, P> fundido) {
        FundidoManager.nuevo((AbstractPartida)CastUtil.cast((Object)this), fundido);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerLogginEventImportant(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        this.jugadorManager.get(player).ifPresent(jugador -> jugador.actualizarInstancia(player));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerDeadEventImportant(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.jugadorManager.get(player).ifPresent(jugador -> jugador.alMorir(this.jugadorManager.get(player.getKiller()), player.getLocation().clone()));
    }

    protected void enviarTitulo(String titulo, String subtitulo, int fadeIn, int stay, int fadeOut) {
        Title tituloCreado = Title.title((Component)PyronixPlugin.format(titulo, false), (Component)PyronixPlugin.format(subtitulo, false), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeIn), (Duration)Duration.ofMillis(stay), (Duration)Duration.ofMillis(fadeOut)));
        this.jugadorManager.ejecutarFuncionTodosLosJugadores(jugador -> {
            Player player = jugador.getMinecraftPlayer();
            if (jugador.esMinecraftPlayerValido()) {
                player.showTitle(tituloCreado);
                player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        });
    }

    public void borrarEquipos() {
        this.equipoManager.removeAll();
        this.jugadorManager.removeAll();
    }

    public void resetExtra() {
    }

    public final void reset() {
        this.resetExtra();
        this.resetManager.reset();
        this.jugadorManager.removeAll();
        this.componentSystem.remove(RegistrosBase.COMPONENTES.MAPA);
        this.setEstado(EnumEstadoPartida.EN_ESPERA);
    }

    public final void resetCompleto() {
        this.resetExtraCompleto();
        this.reset();
        PyronixPlugin.desregistrarEventos(this);
        this.resetManager.resetCompleto();
        this.borrarEquipos();
    }

    public void resetExtraCompleto() {
    }
}

