/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.mapa;

import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.mapa.TipoMarcador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.base.util.Ubicacion;
import es.pyronixstudio.util.colecciones.ColeccionesUtil;
import es.pyronixstudio.util.ficheros.Elemento;
import es.pyronixstudio.util.ficheros.PyronixFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MarcadorConfiguracion {
    private final Elemento configMapa;
    public final Elemento config;
    public final TipoMarcador tipoMarcador;
    public final Material material;
    public final ItemStack stack;
    private final World world;
    private final boolean borrarEnMundo;
    public final boolean reseteable;
    protected Set<Location> ubicaciones = new HashSet<Location>();
    private String id;
    public static final String PREFIX = "m";

    public static String idConPrefijo(String id) {
        return String.format("%s-%s", PREFIX, id);
    }

    public MarcadorConfiguracion(Elemento configMarcador, Elemento configMapa, World world) {
        this.configMapa = configMapa;
        this.config = configMarcador;
        this.tipoMarcador = (TipoMarcador)RegistrosBase.TIPO_MARCADORES.get(configMarcador.get("tipo").asString()).crear();
        this.material = (Material)configMarcador.get("material").asEnum(Material.class);
        this.id = configMarcador.id;
        this.world = world;
        this.borrarEnMundo = this.config.getOrDefault("quitar", (Object)true).asBoolean();
        this.reseteable = this.config.getOrDefault("reseteable", (Object)false).asBoolean();
        ItemStack stack = new ItemStack(this.material);
        ItemMeta meta = stack.getItemMeta();
        Component componente = PyronixPlugin.format(String.format("<green>\u00f0\u0178\u0152\u0178<red>%s<reset><green>\u00f0\u0178\u0152\u0178", configMarcador.get("titulo").asString()), false).decoration(TextDecoration.ITALIC, false);
        meta.displayName(componente);
        stack.setItemMeta(meta);
        this.stack = stack;
        if (configMapa != null) {
            this.llenarUbicaciones();
        }
    }

    private void llenarUbicaciones() {
        int indice = 0;
        for (int i = 0; i < this.configMapa.size(); i += 3) {
            this.ubicaciones.add(Ubicacion.getLocation(this.world, this.configMapa, Integer.toString(indice)));
            ++indice;
        }
    }

    public void borrar() {
        this.ubicaciones.clear();
    }

    public void agregarUbicacionSiNoExiste(Block block) {
        Location location = block.getLocation();
        if (block.getType() == this.material && !this.tieneUbicacion(location)) {
            this.ubicaciones.add(location);
        }
    }

    public void guardar(PyronixFile config) {
        Elemento elemento = Elemento.empty((String)MarcadorConfiguracion.idConPrefijo(this.id));
        if (this.ubicaciones.isEmpty()) {
            config.borrarElemento(elemento);
            return;
        }
        int index = 0;
        for (Location location : this.ubicaciones) {
            Ubicacion.escribir(elemento, location, Integer.toString(index++), false);
            if (!this.borrarEnMundo) continue;
            this.colocarDescolocarEnMundo(location, false);
        }
        config.agregarElemento(elemento);
    }

    private boolean tieneUbicacion(Location location) {
        return this.ubicaciones.contains(location);
    }

    public void colocar() {
        if (this.reseteable) {
            return;
        }
        for (Location location : this.ubicaciones) {
            this.colocarDescolocarEnMundo(location, true);
        }
    }

    private void colocarDescolocarEnMundo(Location location, boolean colocar) {
        location.getBlock().setType(colocar ? this.material : Material.AIR);
    }

    public Set<Location> getUbicaciones() {
        return this.ubicaciones;
    }

    public Location getPrimeraUbicacion() {
        return this.getUbicacionesAsList().getFirst();
    }

    public List<Location> getUbicacionesAsList() {
        return (List)ColeccionesUtil.toCollection(this.getUbicaciones(), new ArrayList());
    }

    public String toString() {
        return String.format("ID:%s Ubic:%s", this.id, this.ubicaciones);
    }
}

