/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.equipo;

import es.pyronixstudio.base.componentes.Componente;
import es.pyronixstudio.base.componentes.SistemaComponente;
import es.pyronixstudio.base.core.PyronixPlugin;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.IReseteable;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

public abstract class AbstractEquipo<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
implements IReseteable {
    private static Map<EnumColor, Map<Componente<?>, Object>> componentesExtras;
    protected Set<UUID> jugadores = new HashSet<UUID>();
    public final SistemaComponente componentSystem = SistemaComponente.create();
    public final P partida;

    public AbstractEquipo(EnumColor color, P partida) {
        this.partida = partida;
        this.registrarComponentesBase(color);
    }

    protected void registrarComponentesExtras(Map<EnumColor, Map<Componente<?>, Object>> componentesExtras) {
    }

    private void registrarComponentesBase(EnumColor color) {
        Map<Componente<?>, Object> extra;
        this.componentSystem.add(RegistrosBase.COMPONENTES.COLOR, color);
        this.componentSystem.add(RegistrosBase.COMPONENTES.TRIM, color.trim);
        this.componentSystem.add(RegistrosBase.COMPONENTES.INGLES, color.ingles);
        if (componentesExtras == null) {
            HashMap mapa = new HashMap();
            this.registrarComponentesExtras(mapa);
            componentesExtras = Map.copyOf(mapa);
        }
        if ((extra = componentesExtras.get((Object)color)) != null) {
            this.componentSystem.putAll(extra);
        }
    }

    public boolean agregarJugador(UUID uuid) {
        return this.jugadores.add(uuid);
    }

    public final void setJugadores(Collection<UUID> jugadoresEquipo) {
        this.jugadores.clear();
        this.jugadores.addAll(jugadoresEquipo);
    }

    public void borrarJugadores() {
        this.jugadores.clear();
    }

    public final Set<UUID> getJugadores() {
        return this.jugadores;
    }

    public final EnumColor getColor() {
        return (EnumColor)((Object)this.componentSystem.get(RegistrosBase.COMPONENTES.COLOR));
    }

    public final Optional<Player> getPlayer(UUID uuid) {
        if (!this.jugadores.contains(uuid)) {
            return Optional.empty();
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isConnected()) {
            return Optional.ofNullable(player);
        }
        return Optional.empty();
    }

    public final void ejecutarFuncionTodosLosMinecraftPlayer(Consumer<Player> minecraftPlayerConsumer) {
        this.jugadores.stream().forEach(uuid -> {
            Optional<Player> playerOptional = this.getPlayer((UUID)uuid);
            if (playerOptional.isEmpty()) {
                return;
            }
            minecraftPlayerConsumer.accept(playerOptional.get());
        });
    }

    protected void ponerArmadurasATodos(ItemStack[] armor) {
        this.ejecutarFuncionTodosLosMinecraftPlayer(player -> this.ponerArmadura(player.getUniqueId(), armor));
    }

    protected final void ponerArmadura(UUID uuid, ItemStack[] armor) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isValid()) {
            player.getInventory().setArmorContents(armor);
        }
    }

    protected final ItemStack getStackWithTrimAndIrrompible(ItemStack stack) {
        if (stack != null && stack.getItemMeta() != null && stack.getItemMeta() instanceof ArmorMeta) {
            ArmorMeta meta = (ArmorMeta)stack.getItemMeta();
            meta.setUnbreakable(true);
            meta.addEnchant(Enchantment.BINDING_CURSE, 1, true);
            ArmorTrim armorTrim = new ArmorTrim(TrimMaterial.REDSTONE, (TrimPattern)this.componentSystem.get(RegistrosBase.COMPONENTES.TRIM));
            EnumColor color = this.getColor();
            Component componente = PyronixPlugin.format(String.format("<green>Vestimenta equipo %s", color.formatedColoredName()), false).decoration(TextDecoration.ITALIC, false);
            meta.displayName(componente);
            meta.setTrim(armorTrim);
            meta.addAttributeModifier(Attribute.ARMOR, new AttributeModifier(PyronixPlugin.generateKey("armor"), 0.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY));
            stack.setItemMeta((ItemMeta)meta);
            return stack;
        }
        return null;
    }

    public abstract void preIniciar();

    public final void tpJugadoresSpawn() {
        Location spawn = (Location)this.componentSystem.get(RegistrosBase.COMPONENTES.SPAWN);
        if (spawn != null) {
            this.ejecutarFuncionTodosLosMinecraftPlayer(player -> player.teleport(spawn));
        }
    }
}

