/*
 * Decompiled with CFR 0.152.
 */
package es.pyronixstudio.base.juego.areas;

import com.destroystokyo.paper.ParticleBuilder;
import es.pyronixstudio.base.juego.ITickable;
import es.pyronixstudio.base.juego.areas.Area;
import es.pyronixstudio.base.juego.areas.BaseParticulasHelperAreas;
import es.pyronixstudio.base.juego.areas.IAreaRenderable;
import es.pyronixstudio.base.juego.areas.ParticulasHelperAreas2D;
import es.pyronixstudio.base.juego.equipo.AbstractEquipo;
import es.pyronixstudio.base.juego.equipo.EnumColor;
import es.pyronixstudio.base.juego.partida.AbstractPartida;
import es.pyronixstudio.base.juego.partida.jugador.AbstractJugador;
import es.pyronixstudio.base.registros.RegistrosBase;
import es.pyronixstudio.util.CastUtil;
import es.pyronixstudio.util.wrapper.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Particle;

public abstract class AccionCaptura<J extends AbstractJugador<J, E, P>, E extends AbstractEquipo<J, E, P>, P extends AbstractPartida<J, E, P>>
extends Area<J, E, P>
implements ITickable,
IAreaRenderable {
    protected final Map<EnumColor, DatosCaptura> jugadoresCapturando;
    protected final E equipoBandera;

    protected AccionCaptura(Area.Builder builder, Map<EnumColor, DatosCaptura> captura) {
        super(builder);
        this.jugadoresCapturando = captura;
        this.equipoBandera = (AbstractEquipo)this.partida.equipoManager.get((EnumColor)((Object)this.componentSystem.get(RegistrosBase.COMPONENTES.COLOR))).get();
    }

    @Override
    public boolean reset(AbstractPartida<?, ?, ?> partida) {
        this.quitarBloqueYArea();
        return false;
    }

    @Override
    public void setParticleHelper(Wrapper<BaseParticulasHelperAreas> baseHelper) {
        ParticleBuilder particleBuilder = new ParticleBuilder(Particle.DUST);
        EnumColor color = this.equipoBandera == null ? EnumColor.BLANCO : ((AbstractEquipo)this.equipoBandera).getColor();
        particleBuilder.color(color.colorHex);
        baseHelper.set((Object)new ParticulasHelperAreas2D(this, particleBuilder, 1.15));
    }

    @Override
    public void tick() {
        this.comprobarPorcentaje();
        int total = this.jugadoresCapturando.values().stream().mapToInt(DatosCaptura::cantidadJugadores).sum();
        for (Map.Entry<EnumColor, DatosCaptura> entry : this.jugadoresCapturando.entrySet()) {
            int restantes;
            DatosCaptura datos = entry.getValue();
            int cantidad = datos.cantidadJugadores();
            datos.cantidadJugadoresValidos = restantes = Math.max(0, cantidad - (total - cantidad));
            datos.tick();
        }
    }

    private void comprobarPorcentaje() {
        for (Map.Entry<EnumColor, DatosCaptura> entry : this.jugadoresCapturando.entrySet()) {
            DatosCaptura datos = entry.getValue();
            if (datos.getPorcentaje() < datos.porcentajeMax) continue;
            AbstractJugador<?, ?, ?> jugador = datos.getJugadorMasAntiguo();
            this.capturado((AbstractJugador)CastUtil.cast(jugador));
            return;
        }
    }

    protected abstract void capturado(J var1);

    protected void quitarBloqueYArea() {
        this.desregistrar();
        this.centro.getBlock().setType(Material.AIR);
    }

    private List<J> obtenerListaCorrecta(J jugador) {
        return (List)CastUtil.cast(this.jugadoresCapturando.get((Object)((Object)((AbstractEquipo)((AbstractJugador)jugador).getEquipo()).getColor())).capturando);
    }

    @Override
    protected void onEnter(J jugador) {
        this.obtenerListaCorrecta(jugador).add(jugador);
    }

    @Override
    protected void onExit(J jugador) {
        this.obtenerListaCorrecta(jugador).remove(jugador);
    }

    public static class DatosCaptura
    implements ITickable {
        private int porcentaje = 0;
        private final int porcentajeMax;
        private int aSumarBase;
        private int aSumarExtra;
        public int cantidadJugadoresValidos;
        private final List<AbstractJugador<?, ?, ?>> capturando = new ArrayList();

        public static DatosCaptura of(int porcentajeMax, int base, int extra) {
            return new DatosCaptura(porcentajeMax, base, extra);
        }

        public DatosCaptura(int porcentajeMax, int base, int extra) {
            this.porcentajeMax = porcentajeMax;
            this.aSumarBase = base;
            this.aSumarExtra = extra;
        }

        public void setaSumarBase(int aSumarBase) {
            this.aSumarBase = aSumarBase;
        }

        public int getaSumarBase() {
            return this.aSumarBase;
        }

        public void setaSumarExtra(int aSumarExtra) {
            this.aSumarExtra = aSumarExtra;
        }

        public void agregarJugador(AbstractJugador<?, ?, ?> jugador) {
            this.capturando.add(jugador);
        }

        public void borrarJugador(AbstractJugador<?, ?, ?> jugador) {
            this.capturando.remove(jugador);
        }

        public int getPorcentaje() {
            return this.porcentaje;
        }

        public int cantidadJugadores() {
            return this.capturando.size();
        }

        public AbstractJugador<?, ?, ?> getJugadorMasAntiguo() {
            return this.capturando.isEmpty() ? null : this.capturando.getFirst();
        }

        @Override
        public void tick() {
            int cantidadJugadoresValidosEnTick = this.cantidadJugadoresValidos;
            int aSumarActual = this.aSumarBase + this.aSumarExtra * (cantidadJugadoresValidosEnTick - 1);
            if (cantidadJugadoresValidosEnTick > 0) {
                this.porcentaje = this.aSumar(this.porcentaje, aSumarActual, this.porcentajeMax);
            }
        }

        private int aSumar(int porcentajeActual, int aSumar, int max) {
            int aSumarResultado = porcentajeActual + aSumar;
            if (aSumarResultado > max) {
                aSumarResultado = max;
            }
            return aSumarResultado;
        }
    }
}

